/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.ResourceSynchronizationUtils;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.ui.actions.Messages;
import com.aptana.ide.syncing.ui.dialogs.ChooseSiteConnectionDialog;
import com.aptana.ide.syncing.ui.editors.EditorUtils;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.IStudioAnalytics;
import com.aptana.usage.UsagePlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BaseSyncAction
implements IObjectActionDelegate,
IViewActionDelegate {
    private IWorkbenchPart fActivePart;
    private List<IAdaptable> fSelectedElements = new ArrayList<IAdaptable>();
    private ISiteConnection fSite;
    protected IFileStore fSourceRoot;
    protected IFileStore fDestinationRoot;
    protected boolean fSelectedFromSource;

    protected BaseSyncAction() {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fActivePart = targetPart;
    }

    public void run(IAction action) {
        if (this.fSelectedElements.size() == 0) {
            return;
        }
        if (this.fSite == null) {
            ISiteConnection[] sites = this.getSiteConnections();
            if (sites.length == 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessageTitle(), (String)Messages.BaseSyncAction_Warning_NoCommonParent);
                return;
            }
            if (sites.length == 1) {
                this.fSite = sites[0];
            } else {
                IResource resource = (IResource)this.fSelectedElements.get(0).getAdapter(IResource.class);
                if (resource != null) {
                    IContainer container = null;
                    boolean remember = false;
                    if (resource instanceof IContainer && (remember = ResourceSynchronizationUtils.isRememberDecision((IContainer)((IContainer)resource)))) {
                        container = (IContainer)resource;
                    }
                    if (!remember) {
                        container = resource.getParent();
                        while (container != null && !(container instanceof IWorkspaceRoot)) {
                            remember = ResourceSynchronizationUtils.isRememberDecision((IContainer)container);
                            if (remember) break;
                            container = container.getParent();
                        }
                    }
                    if (remember) {
                        this.fSite = this.getLastSyncConnection(container);
                    }
                }
                if (this.fSite == null) {
                    ChooseSiteConnectionDialog dialog = new ChooseSiteConnectionDialog(this.getShell(), sites);
                    dialog.setShowRememberMyDecision(true);
                    if (dialog.open() == 0) {
                        this.fSite = dialog.getSelectedSite();
                        if (this.fSite != null) {
                            this.setRememberMyDecision(this.fSite, dialog.isRememberMyDecision());
                        }
                    }
                }
            }
        }
        if (this.fSite != null) {
            try {
                this.performAction(this.fSelectedElements.toArray(new IAdaptable[this.fSelectedElements.size()]), this.fSite);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        this.setSelection(selection);
        this.setSelectedSite(null);
        action.setEnabled(this.fSelectedElements.size() > 0);
    }

    public void setSelectedSite(ISiteConnection site) {
        this.fSite = site;
    }

    public void setSourceRoot(IFileStore sourceRoot) {
        this.fSourceRoot = sourceRoot;
    }

    public void setDestinationRoot(IFileStore destinationRoot) {
        this.fDestinationRoot = destinationRoot;
    }

    public void init(IViewPart view) {
        this.fActivePart = view;
    }

    public void setSelection(ISelection selection) {
        this.fSelectedElements.clear();
        Object[] elements = ((IStructuredSelection)selection).toArray();
        boolean fromSource = true;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                if (SiteConnectionUtils.findSitesForSource((IAdaptable)adaptable).length > 0) {
                    this.fSelectedElements.add(adaptable);
                } else if (SiteConnectionUtils.findSitesWithDestination((IAdaptable)adaptable).length > 0) {
                    if (fromSource) {
                        fromSource = false;
                    }
                    this.fSelectedElements.add(adaptable);
                }
            }
            ++n2;
        }
        this.fSelectedFromSource = fromSource;
    }

    public void setSelection(ISelection selection, boolean fromSource) {
        Object[] elements;
        this.fSelectedFromSource = fromSource;
        this.fSelectedElements.clear();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection[] sites;
            Object element = objectArray[n2];
            if (element instanceof IAdaptable && (sites = this.fSelectedFromSource ? SiteConnectionUtils.findSitesForSource((IAdaptable)((IAdaptable)element)) : SiteConnectionUtils.findSitesWithDestination((IAdaptable)((IAdaptable)element))).length > 0) {
                this.fSelectedElements.add((IAdaptable)element);
            }
            ++n2;
        }
    }

    protected abstract void performAction(IAdaptable[] var1, ISiteConnection var2) throws CoreException;

    protected String getMessageTitle() {
        return StringUtil.ellipsify((String)Messages.BaseSyncAction_MessageTitle);
    }

    protected Shell getShell() {
        return this.fActivePart.getSite().getShell();
    }

    private ISiteConnection[] getSiteConnections() {
        ArrayList sitesList = new ArrayList();
        HashSet<ISiteConnection> sitesSet = new HashSet<ISiteConnection>();
        for (IAdaptable element : this.fSelectedElements) {
            ISiteConnection[] sites = this.fSelectedFromSource ? SiteConnectionUtils.findSitesForSource((IAdaptable)element) : SiteConnectionUtils.findSitesWithDestination((IAdaptable)element);
            sitesSet.clear();
            ISiteConnection[] iSiteConnectionArray = sites;
            int n = sites.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteConnection site = iSiteConnectionArray[n2];
                sitesSet.add(site);
                ++n2;
            }
            sitesList.add(sitesSet);
        }
        Set<ISiteConnection> sitesSets = SyncUtils.getIntersection(sitesList.toArray(new Set[sitesList.size()]));
        return sitesSets.toArray(new ISiteConnection[sitesSets.size()]);
    }

    protected void openConnectionEditor() {
        ISiteConnection[] sites = this.getSiteConnections();
        if (sites.length > 0) {
            EditorUtils.openConnectionEditor(sites[0]);
        }
    }

    private ISiteConnection getLastSyncConnection(IContainer container) {
        if (container == null) {
            return null;
        }
        String lastConnection = ResourceSynchronizationUtils.getLastSyncConnection((IContainer)container);
        if (lastConnection == null) {
            return null;
        }
        ISiteConnection[] sites = this.fSelectedFromSource ? SiteConnectionUtils.findSitesForSource((IAdaptable)container, (boolean)true) : SiteConnectionUtils.findSitesWithDestination((IAdaptable)container, (boolean)true);
        ISiteConnection[] iSiteConnectionArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            String target;
            ISiteConnection site = iSiteConnectionArray[n2];
            IConnectionPoint destination = site.getDestination();
            if (destination != null && (target = destination.getName()).equals(lastConnection)) {
                return site;
            }
            ++n2;
        }
        return null;
    }

    private void setRememberMyDecision(ISiteConnection site, boolean rememberMyDecision) {
        IConnectionPoint source = site.getSource();
        IResource resource = (IResource)source.getAdapter(IResource.class);
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            ResourceSynchronizationUtils.setRememberDecision((IContainer)container, (boolean)rememberMyDecision);
            ResourceSynchronizationUtils.setLastSyncConnection((IContainer)container, (String)site.getDestination().getName());
        }
    }

    protected void sendEvent(AnalyticsEvent featureEvent) {
        UsagePlugin plugin = UsagePlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IStudioAnalytics analytics = plugin.getStudioAnalytics();
        if (analytics == null) {
            return;
        }
        analytics.sendEvent(featureEvent);
    }
}

